export interface Customer {
  id: string;
  full_name: string;
  email: string;
  phone: string;
  created_at: string;
}

export interface VendorCustomer {
  id: string;
  vendor_id: string;
  customer_id: string;
  tags: string[];
  display_name?: string;
  created_at: string;
}

export interface Measurement {
  id: string;
  vendor_id: string;
  customer_id: string;
  bust?: number;
  waist?: number;
  hip?: number;
  [key: string]: any;
  created_at: string;
  updated_at: string;
}

export interface CustomerProfile {
  customer: Customer;
  vendor_customer: VendorCustomer;
  measurements: Measurement | null;
}

export interface AddOrLinkCustomerRequest {
  full_name: string;
  email: string;
  phone: string;
  tags?: string[];
}

export interface UpdateCustomerRequest {
  full_name?: string;
  tags?: string[];
}

export interface MeasurementRequest {
  bust?: number;
  waist?: number;
  hip?: number;
  [key: string]: any;
} 